/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.spelling;

import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpellingPreferences
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String PREF_DELEIMITER = ",";
    private List<IScopeSelector> selectors;

    public SpellingPreferences() {
        InstanceScope.INSTANCE.getNode("com.aptana.editor.common").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void dispose() {
        InstanceScope.INSTANCE.getNode("com.aptana.editor.common").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("com.aptana.editor.common.enabledSpellingScopes".equals(event.getKey())) {
            this.selectors = null;
        }
    }

    public boolean isSpellingEnabledFor(QualifiedContentType contentType) {
        for (IScopeSelector selector : this.getEnabledSelectors()) {
            if (!selector.matches(contentType.getLastPart())) continue;
            return true;
        }
        return false;
    }

    private List<IScopeSelector> getEnabledSelectors() {
        if (this.selectors == null) {
            this.selectors = new ArrayList<IScopeSelector>();
            for (String scope : SpellingPreferences.getEnabledScopes()) {
                this.selectors.add((IScopeSelector)new ScopeSelector(scope));
            }
        }
        return this.selectors;
    }

    public static Set<String> getEnabledScopes() {
        HashSet<String> result = new HashSet<String>();
        String enabledScopes = Platform.getPreferencesService().getString("com.aptana.editor.common", "com.aptana.editor.common.enabledSpellingScopes", "", new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE});
        String[] stringArray = enabledScopes.split(PREF_DELEIMITER);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String scope = stringArray[n2];
            if ((scope = scope.trim()).length() > 0) {
                result.add(scope);
            }
            ++n2;
        }
        return result;
    }

    public static void setEnabledScopes(Collection<String> scopes) {
        StringBuilder sb = new StringBuilder();
        for (String scope : scopes) {
            if ((scope = scope.trim()).length() <= 0) continue;
            sb.append(scope).append(PREF_DELEIMITER);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        InstanceScope.INSTANCE.getNode("com.aptana.editor.common").put("com.aptana.editor.common.enabledSpellingScopes", sb.toString());
    }
}

